unit fROR_508PatientEdLocal;
{
================================================================================
*
*       Package:        ROR - Clinical Case Registries
*       Date Created:   August 06, 2014
*       Site:           Hines OIFO
*       Developers:     Ed Micyus
*       Description:    Data entry window used to replace TMS advanced column
*                       grid for visually impaired users.
*
*       Notes:
*
================================================================================
}

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

type
  TForm508PatientEdLocal = class(TForm)
    chkName0: TCheckBox;
    lblDesc0: TLabel;
    edtDesc0: TEdit;
    lblDate0: TLabel;
    edtDate0: TEdit;
    lblComment0: TLabel;
    edtComment0: TEdit;
    btnOK: TButton;
    btnCancel: TButton;
    pnlInstruct: TPanel;
    stxtInstruct: TStaticText;
    procedure FormShow(Sender: TObject);
    procedure checkBoxClick(Sender: TObject);
    procedure edtDateExit(Sender: TObject);
    procedure edtCommentExit(Sender: TObject);
  private
    { Private declarations }
    fListData: TStringList;
    fChecks: TStringList;
    fNames:  TStringList;
    fDescs: TStringList;
    fDates: TStringList;
    fComments: TStringList;
  public
    { Public declarations }
    constructor Create(aList: TStringList; aOwner: TComponent = nil); reintroduce;
    destructor  Destroy; override;

    property ListData: TStringList          read fListData;

    function Edit: integer;
  end;

var
  Form508PatientEdLocal: TForm508PatientEdLocal;

implementation

uses uROR_Common, uROR_Utilities, uROR_Strings;

{$R *.dfm}

constructor TForm508PatientEdLocal.Create(aList: TStringList; aOwner: TComponent);
var i: integer;
  chk: TCheckBox;
  lbl1, lbl2, lbl3: TLabel;
  edt1, edt2, edt3: TEdit;
begin
  if Assigned(aOwner) then
    inherited Create(aOwner)
  else
    inherited Create(Application);

  fListData := aList;
  fChecks := TStringList.Create;
  fNames := TStringList.Create;
  fDescs := TStringList.Create;
  fDates := TStringList.Create;
  fComments := TStringList.Create;

  for i := 0 to fListData.Count - 1 do
  begin
    fChecks.Add(Piece(fListData[i], U, 1));
    fNames.Add(Piece(fListData[i], U, 2));
    fDescs.Add(Piece(fListData[i], U, 3));
    fDates.Add(Piece(fListData[i], U, 4));
    fComments.Add(Piece(fListData[i], U, 5));
  end;

  //Load values for first item
  chkName0.Checked := (fChecks[0] = '1');
  chkName0.Caption := fNames[0];
  edtDesc0.Text    := fDescs[0];
  edtDate0.Text    := fDates[0];
  edtComment0.Text := fComments[0];

  //Create checkboxes, labels and edit controls for the remainder of the list
  for i := 1 to fListData.Count - 1 do
  begin
    chk := TCheckBox.Create(self);
    chk.Name    := Format('chkName%d', [i]);
    chk.Tag     := i;
    chk.Checked := (fChecks[i] = '1');
    chk.Caption := fNames[i];
    chk.Left    := chkName0.Left;
    chk.Top     := chkName0.Top + (i * 72);
    chk.Width   := chkName0.Width;
    chk.OnClick := checkBoxClick;
    chk.Parent  := self;

    lbl1 := TLabel.Create(self);
    lbl1.Name    := Format('lblDesc%d', [i]);
    lbl1.Caption := lblDesc0.Caption;
    lbl1.Left    := lblDesc0.Left;
    lbl1.Top     := lblDesc0.Top + (i * 72);
    lbl1.Parent  := self;

    edt1 := TEdit.Create(self);
    edt1.Name       := Format('edtDesc%d', [i]);
    edt1.Color      := edtDesc0.Color;
    edt1.Tag        := i;
    edt1.Text       := fDescs[i];
    edt1.Left       := edtDesc0.Left;
    edt1.Top        := edtDesc0.Top + (i * 72);
    edt1.Width      := edtDesc0.Width;
    edt1.ReadOnly   := true;
    edt1.Parent     := self;

    lbl2         := TLabel.Create(self);
    lbl2.Name    := Format('lblDate%d', [i]);
    lbl2.Caption := lblDate0.Caption;
    lbl2.Left    := lblDate0.Left;
    lbl2.Top     := lblDate0.Top + (i * 72);
    lbl2.Parent  := self;

    edt2            := TEdit.Create(self);
    edt2.Name       := Format('edtDate%d', [i]);
    edt2.Tag        := i;
    edt2.Text       := fDates[i];
    edt2.Left       := edtDate0.Left;
    edt2.Top        := edtDate0.Top + (i * 72);
    edt2.Width      := edtDate0.Width;
    edt2.OnExit     := edtDateExit;
    edt2.Parent     := self;

    lbl3         := TLabel.Create(self);
    lbl3.Name    := Format('lblComment%d', [i]);
    lbl3.Caption := lblComment0.Caption;
    lbl3.Left    := lblComment0.Left;
    lbl3.Top     := lblComment0.Top + (i * 72);
    lbl3.Parent  := self;

    edt3            := TEdit.Create(self);
    edt3.Name       := Format('edtComment%d', [i]);
    edt3.Tag        := i;
    edt3.Text       := fComments[i];
    edt3.Left       := edtComment0.Left;
    edt3.Top        := edtComment0.Top + (i * 72);
    edt3.Width      := edtComment0.Width;
    edt3.MaxLength  := edtComment0.MaxLength;
    edt3.OnExit     := edtCommentExit;
    edt3.Parent     := self;

    self.Height := self.Height + 72;
  end;
end;

destructor TForm508PatientEdLocal.Destroy;
begin
  fListData := nil;
  inherited;
end;

procedure TForm508PatientEdLocal.FormShow(Sender: TObject);
begin
  stxtInstruct.SetFocus;
end;

procedure TForm508PatientEdLocal.checkBoxClick(Sender: TObject);
var iTag: integer;
begin
  iTag := (Sender as TCheckBox).Tag;
  if (Sender as TCheckBox).Checked then
    ListData[iTag] := '1' + U + piece(ListData[iTag], U, 2, 5)
  else
    ListData[iTag] := '0' + U + piece(ListData[iTag], U, 2, 5);
end;

function TForm508PatientEdLocal.Edit: Integer;
begin
  Result := ShowModal;
end;

procedure TForm508PatientEdLocal.edtDateExit(Sender: TObject);
var iTag: integer;
    tmpDate: TDateTime;
    tmpStr: string;
begin
  iTag := (Sender as TEdit).Tag;
  tmpStr := trim((Sender as TEdit).Text);
  try
    if Length(tmpStr) > 0 then
      tmpDate := StrToDate(tmpStr);
    ListData[iTag] := piece(ListData[iTag], U, 1, 3) + U + tmpStr + U +
                      piece(ListData[iTag], U, 5);
  except
    MessageDlg508('', RSC50803, mtWarning, [mbOK], 0);
    (Sender as TEdit).SetFocus;
  end;
end;

procedure TForm508PatientEdLocal.edtCommentExit(Sender: TObject);
var iTag: integer;
    tmpStr: string;
begin
  iTag := (Sender as TEdit).Tag;
  tmpStr := trim((Sender as TEdit).Text);
  ListData[iTag] := piece(ListData[iTag], U, 1, 4) + U + tmpStr;
end;

end.
